#include <cvidef.h>

/*=================== Power Ten R Series Include File =========================*/
     
#ifndef __PTRSeries_HEADER
#define __PTRSeries_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)

#define VI_INSTR_WARNING_OFFSET                           (0x3FFC0900L)
#define VI_INSTR_ERROR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define PTRSeries_ERROR_SYNTAX                  (VI_INSTR_ERROR_OFFSET + 0xF0L)

/*****************************************************************************/
/* Define Status Byte and Service Request Register Bits                      */
/*****************************************************************************/
#define	PTRSeries_SB_PROTEVENT	0x02
#define	PTRSeries_SB_ERRORQUERY	0x04
#define	PTRSeries_SB_MAV			0x10
#define	PTRSeries_SB_STANDEVENT	0x20
#define	PTRSeries_SB_SRQ			0x40

/*****************************************************************************/
/* Define Standard Event Register Bits                                       */
/*****************************************************************************/
#define	PTRSeries_SE_OPC			0x01
#define	PTRSeries_SE_ERRORQUERY	0x04
#define	PTRSeries_SE_DEVICEERROR	0x08
#define	PTRSeries_SE_RANGEERROR	0x10
#define	PTRSeries_SE_SYNTAXERROR	0x20
#define	PTRSeries_SE_PWRON		0X80

/*****************************************************************************/
/* Define Protection Event and Protection Condition Register Bits            */
/*****************************************************************************/
#define	PTRSeries_PE_VOLTMODE	0x01
#define	PTRSeries_PE_CURRMODE	0x02
#define	PTRSeries_PE_HW			0x04
#define	PTRSeries_PE_OVP			0x08
#define	PTRSeries_PE_OTP			0x10
#define	PTRSeries_PE_EXTSD		0x20
#define	PTRSeries_PE_FOLD		0x40
#define	PTRSeries_PE_PRGMERROR	0X80

/*****************************************************************************/
/* Define Foldback Modes                                                     */
/*****************************************************************************/
#define	PTRSeries_FB_NORMAL		0x00
#define	PTRSeries_FB_VOLTMODE	0x01
#define	PTRSeries_FB_CURRMODE	0x02

/*****************************************************************************/
/* Maximum time a thread will wait to gain control of the session, in        */
/* milli-seconds.															 */
/* All functions have an exclusive lock by VI session, preventing other      */
/* threads accessing the same function.                                      */
/*****************************************************************************/
#define THREAD_LOCK_TIMEOUT 7000

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus CVIFUNC PTRSeries_init                   (ViRsrc         resourceName,
                                                  ViBoolean      IDQuery,
                                                  ViBoolean      resetDevice,
                                                  ViPSession     instrSession);
                              
ViStatus CVIFUNC PTRSeries_GenerateDCVolt         (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       voltage);
                                        
ViStatus CVIFUNC PTRSeries_GenerateDCCurr         (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       current);
                                        
ViStatus CVIFUNC PTRSeries_GenerateDCVRamp        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       voltage,
                                                  ViReal64       time);
                                          
ViStatus CVIFUNC PTRSeries_GenerateDCCRamp        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       current,
                                                  ViReal64       time);

ViStatus CVIFUNC PTRSeries_OutState               (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      state);

ViStatus CVIFUNC PTRSeries_MeasureDCVolt          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *voltage);
                                    
ViStatus CVIFUNC PTRSeries_MeasureDCCurr          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *current);

ViStatus CVIFUNC PTRSeries_ModeQuery              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViInt16        *mode);

ViStatus CVIFUNC PTRSeries_VoltMode               (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      serviceRequest);

ViStatus CVIFUNC PTRSeries_CurrMode               (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      serviceRequest);

ViStatus CVIFUNC PTRSeries_NormalMode             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[]);

ViStatus CVIFUNC PTRSeries_IsolationRelay         (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      state);

ViStatus CVIFUNC PTRSeries_SenseRelay             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      state);

ViStatus CVIFUNC PTRSeries_ConfigDCVolt           (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       voltage);
                                          
ViStatus CVIFUNC PTRSeries_ConfigDCCurr           (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       current);

ViStatus CVIFUNC PTRSeries_ConfigDCVRamp          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       voltage,
                                                  ViReal64       time);
                                          
ViStatus CVIFUNC PTRSeries_ConfigDCCRamp          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       current,
                                                  ViReal64       time);

ViStatus CVIFUNC PTRSeries_ConfigOVP              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       ovp);
                                      
ViStatus CVIFUNC PTRSeries_ConfigSoftLimits       (ViSession      instruSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       voltage,
                                                  ViReal64       current);

ViStatus CVIFUNC PTRSeries_ConfigPowerOn          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       voltage,
                                                  ViReal64       current,
                                                  ViReal64       ovp);

ViStatus CVIFUNC PTRSeries_ConfigFoldback         (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViInt16        mode);

ViStatus CVIFUNC PTRSeries_ConfigVoltAve          (ViSession      instrSession,
                                                  ViChar         channelName[],
                                                  ViInt16        average);

ViStatus CVIFUNC PTRSeries_ConfigCurrAve          (ViSession      instrSession,
                                                  ViChar         channelName[],
                                                  ViInt16        average);

ViStatus CVIFUNC PTRSeries_ConfigProtEventEnable  (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  protectionEventEnable);

ViStatus CVIFUNC PTRSeries_ConfigStandEventEnable (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  standardEventEnable);

ViStatus CVIFUNC PTRSeries_ConfigSerReqEnable     (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  serviceRequestEnable);

ViStatus CVIFUNC PTRSeries_OutputVoltQuery        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *voltage);
                                          
ViStatus CVIFUNC PTRSeries_OutputCurrQuery        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *current);
                                          
ViStatus CVIFUNC PTRSeries_OutputOVPQuery         (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *OVP);

ViStatus CVIFUNC PTRSeries_OutStateQuery          (ViSession      instruSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      *state);

ViStatus CVIFUNC PTRSeries_IsoRelayQuery          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      *state);

ViStatus CVIFUNC PTRSeries_SenseRelayQuery        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      *state);

                                         
ViStatus CVIFUNC PTRSeries_SoftLimitsQuery        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *voltage,
                                                  ViReal64       *current);

ViStatus CVIFUNC PTRSeries_PowerOnQuery           (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *voltage,
                                                  ViReal64       *current,
                                                  ViReal64       *OVP);

ViStatus PTRSeries_measVoltAveQuery               (ViSession      instrSession,
                                                  ViChar         channelName[],
                                                  ViInt16        *average);

ViStatus PTRSeries_measCurrAveQuery               (ViSession      instrSession,
                                                  ViChar         channelName[],
                                                  ViInt16        *average);

                                       
ViStatus CVIFUNC PTRSeries_SendSWTrigger          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViInt16        triggerType);
                                          
ViStatus CVIFUNC PTRSeries_AbortTrigger           (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[]);

ViStatus CVIFUNC PTRSeries_StatusByteQuery        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  *statusByte,
                                                  ViChar _VI_FAR statusMessage[]);
                                          
ViStatus CVIFUNC PTRSeries_StandEventQuery        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  *standardEventStatusRegister,
                                                  ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC PTRSeries_StandEventEnableQuery  (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  *standardEventEnableRegister,
                                                  ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC PTRSeries_ProtEventQuery         (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  *protEventReg,
                                                  ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC PTRSeries_ProtEventEnableQuery   (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  *protEventEnableRegister,
                                                  ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC PTRSeries_ProtCondQuery          (ViSession       instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  *protCondReg,
                                                  ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC PTRSeries_ServiceReqEnableQuery  (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  unsigned char  *serviceReqEnableRegister,
                                                  ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC PTRSeries_reset                  (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[]);

ViStatus CVIFUNC PTRSeries_clear                  (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[]);

ViStatus CVIFUNC PTRSeries_errorQuery             (ViSession      instrSession,
                                                  ViPInt32       errorCode,
                                                  ViChar _VI_FAR errorMessage[]);
                                    
ViStatus CVIFUNC PTRSeries_errorMessage           (ViSession      instrSession,
                                                  ViStatus       statusCode,
                                                  ViChar _VI_FAR message[]);
                                      
ViStatus CVIFUNC PTRSeries_revisionQuery          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR driverRev[],
                                                  ViChar _VI_FAR instrRev[]);
                                          
ViStatus CVIFUNC PTRSeries_idQuery                (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR idBuffer[]);
                                 
ViStatus CVIFUNC PTRSeries_ModelQuery             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *modelVolt,
                                                  ViReal64       *modelCurr);
                                          
ViStatus CVIFUNC PTRSeries_close                  (ViSession      instrSession);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
